﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="VIRP_WEB.Controls.Custom.BPR.controls_UserControlQuestionnaireSummaryDetails" Codebehind="UserControlQuestionnaireSummaryDetails.ascx.cs" %>
<%@ Register src="BaseControlLabel.ascx" tagname="BaseControlLabel" tagprefix="UserControl" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:GridView 
        ID="GridViewQuestionnaire" 
        runat="server" 
        AutoGenerateColumns="False" Width="100%"
        AllowPaging="false"  
        AllowSorting="false" 
        Caption=" Clinically Relevant Summary " 
        EnableModelValidation="True">
    <EmptyDataTemplate>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No questionnaire responses found.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</EmptyDataTemplate>
    <Columns>
        <asp:BoundField DataField="FORM_RESPONSE_QUESTION_ID" HeaderText="Form Response Detail ID" Visible="false" />
       
       <asp:TemplateField HeaderText="Section" Visible="false" >
            <ItemStyle HorizontalAlign="Left" />
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:HyperLink ID="HyperLinkSection" runat="server" Text='<%# Helpers.AhobprEval(Eval("SectionAndSubSection")) %>' 
                    NavigateUrl='<%# "../QuestionnaireSection.aspx?sectionId=" + Helpers.AhobprEval(Eval("SectionId")) + "&subSectionId=" + Helpers.AhobprEval(Eval("SubsectionId")) %>'></asp:HyperLink>
            </ItemTemplate>
       </asp:TemplateField>

       <asp:TemplateField HeaderText="Question ID" SortExpression="QuestionNumber">
          <HeaderStyle HorizontalAlign="Center" Width="5%"  />
          <ItemStyle HorizontalAlign="Left" />
          <ItemTemplate>
               <asp:HyperLink ID="HyperLinkSection" runat="server" Text='<%# Helpers.AhobprEval(Eval("QuestionNumber")) %>' 
                    NavigateUrl='<%# "../QuestionnaireSection.aspx?sectionId=" + Helpers.AhobprEval(Eval("SectionId")) + "&subSectionId=" + Helpers.AhobprEval(Eval("SubsectionId")) %>'></asp:HyperLink>
            </ItemTemplate>
        </asp:TemplateField>

        <asp:TemplateField HeaderText="Question" >
          <HeaderStyle HorizontalAlign="Center" Width="60%" />
          <ItemStyle HorizontalAlign="Left" />
          <ItemTemplate>
                <asp:Label ID="LabelQuestion" SkinID="DataLabel" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("QuestionText"))) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

      <asp:TemplateField HeaderText="Answer(s)" >
            <ItemStyle HorizontalAlign="Left" />
            <HeaderStyle HorizontalAlign="Center" Width="35%" />
            <ItemTemplate>
                <asp:Label ID="LabelAnswers" runat="server" SkinID="DataLabel" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("AnswerValues"))) %>'></asp:Label>
            </ItemTemplate>
      </asp:TemplateField>
      
     </Columns>
</asp:GridView>

<asp:ObjectDataSource 
    ID="ObjectDataSourceQuestionnaireSummary" runat="server" 
        SelectMethod="GetClinicallyRelevantSummary" 
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRQuestionnaireManager">
    <SelectParameters>
        <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="Int32" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
